* Title: Project Roles
* Slug: project-roles

================================================================

activeCollab <{term}>Project Roles<{/term}> define what a user can do inside a Project. Project Roles are set when you are <{page name="adding-people-to-projects"}>adding users to a Project<{/page}>. A user may have several Project Roles, **different for each Project** they are assigned to. For example, you may allow a user to access Discussions in one Project, but restrict them from even viewing Discussions in another.

<{note title="System and Project Roles"}>Regardless of the Project Role, there are a few people that will always have unlimited access to your Projects, due of their System Role:

- <{term}>Administrator<{/term}> - people with this System Role have unlimited access to all parts of activeCollab, and therefore have unlimited access to all Projects.
- <{term}>Project Leader<{/term}> - person responsible for that specific Project will have access to all Project areas, with no restrictions.
- <{term}>Project Manager<{/term}> - as the global Manager with Manage Projects permission enabled, this person will have unlimited access to all Projects.<{/note}>

<{sub}>Define Project Roles you Need<{/sub}>

Unlike System Roles, there are no predefined Project Roles in activeCollab. Instead, you can create them according to your needs. To start creating a new Project Role, go to the <{term}>Administration > Project Roles<{/term}> section. Click on the <{option}>New Project Role<{/option}> button. Here, you can name the role and choose the permissions you wish for it to have. Once submitted, the role will be saved and available for all upcoming Projects.

<{image name="new_Project_permission.png"}>

To make this job even easier, you can use the <{term}>Gear<{/term}> icon that is available and set the same permission value for all of the items in the Project.

<{sub}>Project Permissions<{/sub}>

Project Permissions are all related to whether the users can view, access or manage certain objects inside the Project. You will recognize these objects as <{term}>Project Tabs<{/term}>.

Here are the Project Permissions taht you can use:

- <{option}>No Access<{/option}> - the user cannot access or even see the tab containing the object. For example, a user that is set to have No Access to Tasks, will not even be aware that the Task tab exists within this Project.
- <{option}>Access Only<{/option}> - the user will have access to the object and will be able to see the relevant Project tab. Using the same example, a user with "Has Access" set for Tasks will be able to see the Task tab and browse all Tasks placed inside it, but will not be able to add any new Tasks (the New Task button will not be displayed) or change any existing ones.
- <{option}>Access and Create<{/option}> - allows users to see the New Object button or, to continue with our previous example, the New Task button and use it to add new Tasks. However, they will still not be able to change anything.
- <{option}>Access, Create and Manage<{/option}> - user will have all the permissions for this object within a Project. They will be able to view, create, edit and delete these objects.

<{sub}>Setting a Project Role<{/sub}> 

You can also set a user's Project role on an ad-hoc basis, while creating a new Project. You can do that after setting up a new Project and filling in the basic information to get things started. You will then need to use to the <{option}>Manage Project People<{/option}> link, in order to start assigning users to that Project. From here, you can **choose any users that you wish to include in that Project and select the Project Role for them**, either by selecting an existing role or creating a custom one and assigning permissions on the spot.

After everything has been set up, you can start working on your Project, knowing that you have full control over who can access or change the data within it.